/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui.entries;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.forge.gui.entries.TextFieldListEntry;
import me.shedaniel.clothconfig2.forge.gui.widget.ColorDisplayWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ColorEntry
extends TextFieldListEntry<Integer> {
    private ColorDisplayWidget colorDisplayWidget;
    private Consumer<Integer> saveConsumer;
    private boolean alpha = true;

    @Deprecated
    @ApiStatus.Internal
    public ColorEntry(ITextComponent fieldName, int value, ITextComponent resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, 0, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        ColorValue colorValue = this.getColorValue(String.valueOf(value));
        if (colorValue.hasError()) {
            throw new IllegalArgumentException("Invalid Color: " + colorValue.getError().name());
        }
        this.alpha = false;
        this.saveConsumer = saveConsumer;
        this.original = value;
        this.textFieldWidget.func_146180_a(this.getHexColorString(value));
        this.colorDisplayWidget = new ColorDisplayWidget(this.textFieldWidget, 0, 0, 20, this.getColorValueColor(this.textFieldWidget.func_146179_b()));
        this.resetButton.field_230697_t_ = button -> this.textFieldWidget.func_146180_a(this.getHexColorString((Integer)defaultValue.get()));
    }

    @Override
    protected boolean isChanged(Integer original, String s) {
        ColorValue colorValue = this.getColorValue(s);
        return colorValue.hasError() || (Integer)this.original != colorValue.color;
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        this.colorDisplayWidget.field_230691_m_ = y;
        ColorValue value = this.getColorValue(this.textFieldWidget.func_146179_b());
        if (!value.hasError()) {
            this.colorDisplayWidget.setColor(this.alpha ? value.getColor() : 0xFF000000 | value.getColor());
        }
        this.colorDisplayWidget.field_230690_l_ = Minecraft.func_71410_x().field_71466_p.func_78260_a() ? x + this.resetButton.func_230998_h_() + this.textFieldWidget.func_230998_h_() : this.textFieldWidget.field_230690_l_ - 23;
        this.colorDisplayWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    @Override
    protected void textFieldPreRender(TextFieldWidget widget) {
        if (!this.getConfigError().isPresent()) {
            widget.func_146193_g(0xE0E0E0);
        } else {
            widget.func_146193_g(0xFF5555);
        }
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        if (!this.getDefaultValue().isPresent()) {
            return false;
        }
        ColorValue colorValue = this.getColorValue(text);
        return !colorValue.hasError() && colorValue.color == (Integer)this.getDefaultValue().get();
    }

    @Override
    public boolean isEdited() {
        ColorValue colorValue = this.getColorValue(this.textFieldWidget.func_146179_b());
        return colorValue.hasError() || colorValue.color != (Integer)this.original;
    }

    @Override
    public Integer getValue() {
        return this.getColorValueColor(this.textFieldWidget.func_146179_b());
    }

    @Deprecated
    public void setValue(int color) {
        this.textFieldWidget.func_146180_a(this.getHexColorString(color));
    }

    @Override
    public Optional<ITextComponent> getError() {
        ColorValue colorValue = this.getColorValue(this.textFieldWidget.func_146179_b());
        if (colorValue.hasError()) {
            return Optional.of(new TranslationTextComponent("text.cloth-config.error.color." + colorValue.getError().name().toLowerCase(Locale.ROOT)));
        }
        return super.getError();
    }

    public void withAlpha() {
        if (!this.alpha) {
            this.alpha = true;
            this.textFieldWidget.func_146180_a(this.getHexColorString((Integer)this.original));
        }
    }

    public void withoutAlpha() {
        if (this.alpha) {
            this.alpha = false;
            this.textFieldWidget.func_146180_a(this.getHexColorString((Integer)this.original));
        }
    }

    protected String stripHexStarter(String hex) {
        if (hex.startsWith("#")) {
            return hex.substring(1);
        }
        return hex;
    }

    protected boolean isValidColorString(String str) {
        return !this.getColorValue(str).hasError();
    }

    protected int getColorValueColor(String str) {
        return this.getColorValue(str).getColor();
    }

    protected ColorValue getColorValue(String str) {
        try {
            int color;
            if (str.startsWith("#")) {
                String stripHexStarter = this.stripHexStarter(str);
                if (stripHexStarter.length() > 8) {
                    return ColorError.INVALID_COLOR.toValue();
                }
                if (!this.alpha && stripHexStarter.length() > 6) {
                    return ColorError.NO_ALPHA_ALLOWED.toValue();
                }
                color = (int)Long.parseLong(stripHexStarter, 16);
            } else {
                color = (int)Long.parseLong(str);
            }
            int a = color >> 24 & 0xFF;
            if (!this.alpha && a > 0) {
                return ColorError.NO_ALPHA_ALLOWED.toValue();
            }
            if (a < 0 || a > 255) {
                return ColorError.INVALID_ALPHA.toValue();
            }
            int r = color >> 16 & 0xFF;
            if (r < 0 || r > 255) {
                return ColorError.INVALID_RED.toValue();
            }
            int g = color >> 8 & 0xFF;
            if (g < 0 || g > 255) {
                return ColorError.INVALID_GREEN.toValue();
            }
            int b = color & 0xFF;
            if (b < 0 || b > 255) {
                return ColorError.INVALID_BLUE.toValue();
            }
            return new ColorValue(color);
        }
        catch (NumberFormatException e) {
            return ColorError.INVALID_COLOR.toValue();
        }
    }

    protected String getHexColorString(int color) {
        return "#" + StringUtils.leftPad((String)Integer.toHexString(color), (int)(this.alpha ? 8 : 6), (char)'0');
    }

    protected static class ColorValue {
        private int color = -1;
        @Nullable
        private ColorError error = null;

        public ColorValue(int color) {
            this.color = color;
        }

        public ColorValue(ColorError error) {
            this.error = error;
        }

        public int getColor() {
            return this.color;
        }

        @Nullable
        public ColorError getError() {
            return this.error;
        }

        public boolean hasError() {
            return this.getError() != null;
        }
    }

    protected static enum ColorError {
        NO_ALPHA_ALLOWED,
        INVALID_ALPHA,
        INVALID_RED,
        INVALID_GREEN,
        INVALID_BLUE,
        INVALID_COLOR;

        private ColorValue value = new ColorValue(this);

        public ColorValue toValue() {
            return this.value;
        }
    }
}

